(

global wndStopWatch
global wndStopWatchPos

startT = timeGetTime()
countedT = 0f
Counting = false
laps = #()
	
rollout roStopWatch "" 
(
	timer uiClock "testClock" interval:15	
	
	Angle uiMsClock "" diameter:30 align:#left range:[-90,360,0] startdegrees:-90 dir:#cw color:blue across:3
	label uiSeq"0." align:#right offset:[-50,10]
	label uiMs "000"  offset:[-50,10]
	
	listbox uiList ""
	
	checkbutton uiStart "START"  width:130 height:100  across:2 --offset:[50,0]
	button uiLap "LAP"  width:130 height:100 --offset:[50,0]

	button uiKey "Make keys" height:30 --across:2
	checkbox uiFitFrame "Fit keys to frame" checked:true offset:[170,-25]
	
	
	on uiStart changed theState do
	(
		if Counting == false then
		(
			uiStart.text = "STOP"
			uiLap.text = "LAP"
			
			Counting = true
			
			startT = timeGetTime() + countedT
		)
		else
		(
			uiStart.text = "START"
			uiLap.text = "RESET"
			
			Counting = false
			
			countedT = (startT - timeGetTime())
		)
	)
	
	on uiLap pressed do
	(
		if Counting then
		(	
			lapT = timeGetTime()
			lap = uiSeq.text + uiMs.text + "s"
			append laps lap
			
			uiList.selection = laps.count
		)else
		(
			countedT = 0f
			uiSeq.text = "0."
			uiMs.text = "000"
			uiMsClock.degrees = 0
			laps = #()
		)
		uiList.items = laps
	)		
	
	on uiClock tick do
	(
		if Counting do
		(			
			endT = timeGetTime()
			
			CalcTime = (endT - startT) as string
			CalcTime = (trimright CalcTime "L") as float
			CalcTime = CalcTime *0.001
			
			Ts = (CalcTime as integer)
			Tms = ((substring ((CalcTime - (Ts-1.0))as string) 2 -1)as float)*1000 -- returns ms
			
			uiSeq.text  = Ts as string + "."
			uiMs.text = (Tms as integer) as string
			uiMsClock.degrees = (Tms * 0.36) as float
		)
	)
	
	on uiKey pressed do
	(
		p = point()
		
		for i = 1 to laps.count do
		(
			with animate on 
			(
				
				Ktime = (laps[i] as time).frame
				
				if uiFitFrame.checked == true then
				(
					t = (floor (Ktime + 0.5))
					t = t as string + "f"
					Ktime = t as time
				)
							
				at time (Ktime as time) 
				(
					p.position = [0,0,0]
				)
				
			)
		)
		select p
	)

)

try( wndStopWatchPos = wndStopWatch.pos; closeRolloutFloater wndStopWatch)catch()
wndStopWatch = newRolloutFloater "StopWatch" 300 360
if wndStopWatchPos == undefined do (wndStopWatchPos =[100,200])
wndStopWatch.pos = wndStopWatchPos
addRollout roStopWatch wndStopWatch	


)